#define RELAY_PIN 0
#define DNS_PORT 53
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <DNSServer.h>
#include <ESP8266mDNS.h>        // Include the mDNS library, MDNS object

char hostName[]="relay.MMMMMMMMMMMM";
uint8_t macAdd[WL_MAC_ADDR_LENGTH];
const char hex[]="0123456789ABCDEF";
char ssidName[WL_SSID_MAX_LENGTH]="SSID";
char ssidPass[WL_WPA_KEY_MAX_LENGTH]="PASSWORD";
#define LOCK_CODE_LEN 64
char lockCode[LOCK_CODE_LEN]="";
bool lockActive=0;
char closedMessage[]="close";
char openMessage[]="open";
char unknownMessage[]="unknown";
char* lastStateMessage=unknownMessage;

String mainLockedPage="<head>"
  "<meta http-equiv=\"refresh\" content=\"30; URL='/'\" /> "    //comment out this line to disable auto-refresh
  "<title>(LOCKED) Help and Configuration for WiFi Relay</title></head>"
  "<a href='/'><h3>WiFi Relay</h3></a>"
  "<p>To open relay, click this link:</p>"
  "<a href='/open' target='_blank'>open</a>"
  "<p>To close relay, click this link:</p>"
  "<a href='/close' target='_blank'>close</a>"
  "<form action=\"/\">"
  "<label for=\"code\">LOCK PASSWORD:</label><br>"
  "<input type=\"text\" id=\"code\" name=\"code\"><br>"
  "<input type=\"submit\" value=\"Unlock\">"
  "</form>"
  ;
String mainPage="<head>"
  "<meta http-equiv=\"refresh\" content=\"30; URL='/'\" /> "    //comment out this line to disable auto-refresh
  "<title>Help and Configuration for WiFi Relay</title></head>"
  "<a href='/'><h3>WiFi Relay</h3></a>"
  "<p>To open relay, click this link:</p>"
  "<a href='/open' target='_blank'>open</a>"
  "<p>To close relay, click this link:</p>"
  "<a href='/close' target='_blank'>close</a>"
  "<p>Add WiFi AP information here and press Submit.</p>"
  "<form action=\"/\">"
  "<label for=\"ssid\">SSID:</label><br>"
  "<input type=\"text\" id=\"ssid\" name=\"ssid\"><br>"
  "<label for=\"pass\">Password:</label><br>"
  "<input type=\"text\" id=\"pass\" name=\"pass\"><br>"
  "<input type=\"submit\" value=\"Submit\">"
  "</form>"
  "<form action=\"/\">"
  "<label for=\"code\">LOCK PASSWORD:</label><br>"
  "<input type=\"text\" id=\"code\" name=\"code\"><br>"
  "<input type=\"submit\" value=\"Lock\">"
  "</form>"
  ;

ESP8266WebServer server(80);
DNSServer dns;
IPAddress apIP(192, 168, 1, 1);
const byte cmdOFF[] = {0xA0, 0x01, 0x01, 0xA2};   //these are reversed in the Jaycar Firmware
const byte cmdON[] = {0xA0, 0x01, 0x00, 0xA1};

//to store network configs
#include <EEPROM.h>
#define EEPROM_SIZE 4096
#define EEPROM_KEY (0xA5)
unsigned long tmout=0;
#define TM_DELAY 1000
bool staUp=0;

void setup(){
  int i;
  pinMode(RELAY_PIN,OUTPUT);
  digitalWrite(RELAY_PIN,HIGH);
  EEPROM.begin(EEPROM_SIZE);
  if(EEPROM.read(WL_SSID_MAX_LENGTH+WL_WPA_KEY_MAX_LENGTH+LOCK_CODE_LEN)!=EEPROM_KEY){
    saveToEEPROM(); //set initial RAM values
    Serial.println("Setting EEPROM to default values");
  } 
  loadFromEEPROM();
  if(lockCode[0]){lockActive=1;}  //code is present
  Serial.begin(9600);
  WiFi.mode(WIFI_AP_STA);   //dual mode
  dns.setTTL(300);
  dns.setErrorReplyCode(DNSReplyCode::ServerFailure);
  dns.start(DNS_PORT, "relay.setup", apIP);
  Serial.println();
  Serial.println("WiFi Relay");
  Serial.println("Setting up Soft-AP..");
  WiFi.macAddress(macAdd);          //get binary
  putMAChex(&hostName[6],macAdd);   //convert to hex, hostName is now relay.[HEXMAC]
  Serial.print("Relay host: ");
  Serial.println(hostName);    
  WiFi.setHostname(hostName);
  WiFi.softAPConfig(apIP, apIP, IPAddress(255, 255, 255, 0));
  if (WiFi.softAP("relay")){
    Serial.println("Connect to the network 'relay' and browse to 'relay.setup' to configure.");
  }else{
    Serial.println("Failed! Resetting...");
    ESP.restart();
  }
  server.on("/", sendIndex);
  server.on("/open", openRelay);
  server.on("/close", closeRelay);
  server.onNotFound(sendNotFound);
  server.begin();
}

void loop(){
  int d,i;
  unsigned int s;
  /*
  while(Serial.available()){
    d=Serial.read();
    if(d=='~'){
      Serial.println("Code cleared");
      for(i=0;i<LOCK_CODE_LEN;i++){
        lockCode[i]=0;
      }
      lockActive=0;
      saveToEEPROM();
    }
    if(d=='d'){
      Serial.print("SSID:");
      Serial.println(ssidName);
      Serial.print("PASS:");
      Serial.println(ssidPass);
      Serial.print("HOST:");
      Serial.println(hostName);    
      Serial.print("IP:");
      Serial.println(WiFi.localIP());
      Serial.print("CODE:");
      Serial.println(lockCode);      
    }
    if(d=='q'){
      Serial.println("Querying MDNS");
      s=MDNS.queryService("http", "tcp");
      Serial.println(s);
      for(i=0;i<s;i++){
        Serial.print(s);
        Serial.print(":  ");
        Serial.print(MDNS.answerHostname(i));
        Serial.print("  at  ");
        Serial.println(MDNS.answerIP(i));
      }
      MDNS.removeQuery();
    }
  }
  */
  dns.processNextRequest();
  MDNS.update();
  server.handleClient();
  if(millis()>(tmout+TM_DELAY)){    //check if connected to an AP
    tmout=millis();
    //Serial.println(WiFi.status());
    switch(WiFi.status()){
      case WL_IDLE_STATUS: WiFi.begin(ssidName,ssidPass); break;
      case WL_NO_SSID_AVAIL: WiFi.disconnect();break;
      case WL_SCAN_COMPLETED: WiFi.disconnect();break;
      case WL_CONNECTED: break;   //all good, nothing to do!
      case WL_CONNECT_FAILED: WiFi.disconnect();break;
      case WL_CONNECTION_LOST: WiFi.disconnect();break;
      case WL_WRONG_PASSWORD: WiFi.disconnect();break;
      case WL_DISCONNECTED: break;  //this is where it is while connecting
      default: WiFi.disconnect();break;
    }    
    if(staUp && (WiFi.status()!=WL_CONNECTED)){ //link has gone down
      Serial.println("Link down");
      MDNS.close();
      staUp=0;
    }
    if(!staUp && (WiFi.status()==WL_CONNECTED)){ //link has come up
      Serial.print("Link up ");
      Serial.println(WiFi.localIP());
      if(MDNS.begin(hostName)) {             // Start the mDNS responder
        Serial.print(hostName);
        Serial.println(".local mDNS responder up.");        
        MDNS.addService("http", "tcp", 80);
      }else{
        Serial.println("mDNS responder did not start.");
      }
      staUp=1;
    }
  }
}

void sendIndex(){
  String pg;
  int i,j,k;
  pg.clear();
  if(lockActive){
  //if(false){
    Serial.println("Locked index page accessed.");
    for(i=0;i<server.args();i++){
      if(server.argName(i).c_str()[0]=='c'){
        //Serial.print(server.arg(i));
        //Serial.println(" entered as code.");
        if(strcmp(server.arg(i).c_str(),lockCode)==0){
          Serial.println("Code cleared");
          for(j=0;j<LOCK_CODE_LEN;j++){
            lockCode[j]=0;
          }
          lockActive=0;
          saveToEEPROM();
          pg=pg+String("<br>Unlock successful");
        }else{
          pg=pg+String("<br>Wrong password");
          delay(10);
        }
      }
    }
  }else{
    //Serial.printf("%d args\r\n",server.args());
    Serial.println("Index page accessed.");
    for(i=0;i<server.args();i++){
      //Serial.print(i);
      //Serial.print(":");
      //Serial.print(server.argName(i));
      //Serial.print("=");
      //Serial.println(server.arg(i));
      if(server.argName(i).c_str()[0]=='c'){
        j=server.arg(i).length();
        if(j>0){
          if(j>=LOCK_CODE_LEN){j=LOCK_CODE_LEN-1;}
          for(k=0;k<j;k++){lockCode[k]=server.arg(i).c_str()[k];}
          lockCode[j]=0;  //null term
          pg=pg+String("<br>Lock code entered");
          saveToEEPROM();
          lockActive=1;
        }
      }
      if(server.argName(i).c_str()[0]=='s'){
        j=server.arg(i).length();
        if(j>0){
          if(j>=WL_SSID_MAX_LENGTH){j=WL_SSID_MAX_LENGTH-1;}
          for(k=0;k<j;k++){ssidName[k]=server.arg(i).c_str()[k];}
          ssidName[j]=0;  //null term
          pg=pg+String("<br>SSID updated");
          saveToEEPROM();
          WiFi.disconnect();    //reconnect to new
        }
      }
      if(server.argName(i).c_str()[0]=='p'){
        j=server.arg(i).length();
        if(j>0){
          if(j>=WL_WPA_KEY_MAX_LENGTH){j=WL_WPA_KEY_MAX_LENGTH-1;}
          for(k=0;k<j;k++){ssidPass[k]=server.arg(i).c_str()[k];}
          ssidPass[j]=0;  //null term
          pg=pg+String("<br>Password updated");
          saveToEEPROM();
          WiFi.disconnect();    //reconnect to new
        }
      }
    }
  }
  if(lockActive){
    pg=mainLockedPage+pg;
  }else{
    pg=pg+String("<br>SSID:")+String(ssidName);
    //pg=pg+String("<br>PASS:")+String(ssidPass);
    //pg=pg+String("<br>CODE:")+String(lockCode);
    pg=pg+String("<br>HOST:")+String(hostName);
    if(MDNS.isRunning()){
      pg=pg+String("<br>MDNS:")+String(hostName)+String(".local");
    }
    pg=pg+String("<br>Station IP: ")+String(WiFi.localIP()[0])+String(".")+String(WiFi.localIP()[1])+String(".")+String(WiFi.localIP()[2])+String(".")+String(WiFi.localIP()[3]);    
    pg=mainPage+pg;
  }
  pg=pg+String("<br>Last relay update: ")+String(lastStateMessage);
  server.send(200, "text/html",pg);
}

void openRelay(){
  Serial.write(cmdON, 4);
  server.send(200, "text/plain", "sent off command");
  digitalWrite(RELAY_PIN,HIGH);
  Serial.println("Open page accessed.");
  lastStateMessage=openMessage;
}

void closeRelay(){
  Serial.write(cmdOFF,4);
  server.send(200, "text/plain", "sent on command");
  digitalWrite(RELAY_PIN,LOW);
  Serial.println("Close page accessed.");
  lastStateMessage=closedMessage;
}

void sendNotFound(){
  server.send(404, "text/plain", "404: Not Found");
}

void putMAChex(char* t, uint8_t* s){  //copy octets as hex digits
  int i;
  for(i=0;i<WL_MAC_ADDR_LENGTH;i++){
    t[i*2]  =hex[(s[i]>>4)&0xF];
    t[i*2+1]=hex[(s[i]>>0)&0xF];
  }
}

void loadFromEEPROM(){
  int i;
  for(i=0;i<WL_SSID_MAX_LENGTH;i++){
    ssidName[i]=EEPROM.read(i);
  }
  for(i=0;i<WL_WPA_KEY_MAX_LENGTH;i++){
    ssidPass[i]=EEPROM.read(i+WL_SSID_MAX_LENGTH);
  }  
  for(i=0;i<LOCK_CODE_LEN;i++){
    lockCode[i]=EEPROM.read(i+WL_SSID_MAX_LENGTH+WL_WPA_KEY_MAX_LENGTH);
  }  
}

void saveToEEPROM(){
  int i;
  for(i=0;i<WL_SSID_MAX_LENGTH;i++){
    EEPROM.write(i,ssidName[i]);
  }
  for(i=0;i<WL_WPA_KEY_MAX_LENGTH;i++){
    EEPROM.write(i+WL_SSID_MAX_LENGTH,ssidPass[i]);
  }
  for(i=0;i<LOCK_CODE_LEN;i++){
    EEPROM.write(i+WL_SSID_MAX_LENGTH+WL_WPA_KEY_MAX_LENGTH,lockCode[i]);
  }
  EEPROM.write(WL_SSID_MAX_LENGTH+WL_WPA_KEY_MAX_LENGTH+LOCK_CODE_LEN,EEPROM_KEY);  //OK!
  EEPROM.commit();
}